//スニペット付き新着記事ショートコード関数
if (!shortcode_exists('newsnipet_list')) {
  add_shortcode('newsnipet_list', 'newsnipet_entries_shortcode');
}
if ( !function_exists( 'newsnipet_entries_shortcode' ) ):
function newsnipet_entries_shortcode($atts) {
  extract(shortcode_atts(array(
    'count' => 5,
    'cats' => 'all',
    'tags' => null,
    'type' => 'default',
    'children' => 0,
    'post_type' => 'post',
    'taxonomy' => 'category',
    'sticky' => 1,
    'random' => 0,
    'modified' => 0,
    'order' => 'desc',
    'action' => null,
    'bold' => 0,
    'arrow' => 0,
    'class' => null,
    'snipet' => 1,
  ), $atts));

  //カテゴリを配列化
  $cat_ids = array();
  if ($cats && $cats != 'all') {
    $cat_ids = explode(',', $cats);
  }
  //タグを配列化
  $tag_ids = array();
  if ($tags && $tags != 'all') {
    $tag_ids = explode(',', $tags);
  }
  //引数配列のセット
  $atts = array(
    'entry_count' => $count,
    'cat_ids' => $cat_ids,
    'tag_ids' => $tag_ids,
    'type' => $type,
    'include_children' => $children,
    'post_type' => $post_type,
    'taxonomy' => $taxonomy,
    'sticky' => $sticky,
    'random' => $random,
    'modified' => $modified,
    'order' => $order,
    'action' => $action,
    'bold' => $bold,
    'arrow' => $arrow,
    'class' => $class,
    'snipet' => $snipet,
  );
  ob_start();
  generate_widgetsnipet_entries_tag($atts);
  // generate_widgetsnipet_entries_tag($count, $type, $categories, $children, $post_type, $taxonomy, $random, $action);
  $res = ob_get_clean();
  return $res;
}
endif;

//汎用エントリースニペット付きウィジェットのタグ生成
if ( !function_exists( 'generate_widgetsnipet_entries_tag' ) ):
// function generate_widgetsnipet_entries_tag($entry_count = 5, $entry_type = ET_DEFAULT, $cat_ids = array(), $include_children = 0, $post_type = null, $taxonomy = 'category', $random = 0, $action = null, $snipet = 1){
function generate_widgetsnipet_entries_tag($atts){
  extract(shortcode_atts(array(
    'entry_count' => 5,
    'cat_ids' => array(),
    'tag_ids' => array(),
    'type' => ET_DEFAULT,
    'include_children' => 0,
    'post_type' => null,
    'taxonomy' => 'category',
    'sticky' => 0,
    'random' => 0,
    'modified' => 0,
    'order' => 'desc',
    'action' => null,
    'exclude_cat_ids' => array(),
    'bold' => 0,
    'arrow' => 0,
    'class' => null,
    'snipet' => 1,
  ), $atts));
  //ランダムが有効な時は関連記事
  if ($random) {
    $prefix = WIDGET_RELATED_ENTRY_CARD_PREFIX;
  } else {
    $prefix = WIDGET_NEW_ENTRY_CARD_PREFIX;
  }

  $args = array(
    'posts_per_page' => $entry_count,
    'no_found_rows' => true,
    'action' => $action,
  );
  if (!$sticky) {
    $args += array(
      'post__not_in' => get_sticky_post_ids(),
    );
  }
  if ($order) {
    $args += array(
      'order' => strtoupper($order),
    );
  }
  if ($post_type) {
    $args += array(
      'post_type' => explode(',', $post_type)
    );
  }
  if ($random && $modified) {
    $args += array(
      'orderby' => array('rand', 'modified'),
    );
  } else {
    if ($random) {
      $args += array(
        'orderby' => 'rand',
      );
    }
    if ($modified) {
      $args += array(
        'orderby' => 'modified',
      );
    }
  }
  //関連記事の場合は表示ページを除外
  if ($random) {
    $post_id = get_the_ID();
    if (isset($args['post__not_in'])) {
      $args['post__not_in'][] = $post_id;
    } else {
      $args['post__not_in'] = array($post_id);
    }
  }
  //除外カテゴリーの設定
  if (!empty($exclude_cat_ids)) {
    // _v($cat_ids);
    // _v($exclude_cat_ids);
    $cat_ids = array_diff($cat_ids, $exclude_cat_ids);
    // _v($cat_ids);
  }
  //カテゴリー・タグの指定
  if ( $cat_ids || $tag_ids ) {
    //_v($cat_ids);
    $tax_querys = array();
    if ($cat_ids) {
      $tax_querys[] = array(
        'taxonomy' => $taxonomy,
        'terms' => $cat_ids,
        'include_children' => $include_children,
        'field' => 'term_id',
        'operator' => 'IN'
      );
    }
    if ($tag_ids) {
      $tax_querys[] = array(
        'taxonomy' => 'post_tag',
        'terms' => $tag_ids,
        'field' => 'term_id',
        'operator' => 'IN'
      );
    }
    //_v($tax_querys);
    $args += array(
      'tax_query' => array(
        $tax_querys,
        'relation' => 'AND'
      )
    );

  }
  // _v($args);
  $thumb_size = get_widget_entries_thumbnail_size($type);

  if ($random) {
    $args = apply_filters('widget_related_entries_args', $args);
    $thumb_size = apply_filters('get_related_entries_thumbnail_size', $thumb_size, $type);
  } else {
    $args = apply_filters('widget_new_entries_args', $args);
    $thumb_size = apply_filters('get_new_entries_thumbnail_size', $thumb_size, $type);
  }
  $args = apply_filters('widget_entries_args', $args);
  //_v($args);
  //query_posts( $args ); //クエリの作成
  $query = new WP_Query( $args );
  $atts = array(
    'type' => $type,
    'bold' => $bold,
    'arrow' => $arrow,
    'class' => $class,
  );
  $cards_classes = get_additional_widget_entry_cards_classes($atts);
  ?>
  <div class="<?php echo $prefix; ?>-entry-cards widget-entry-cards no-icon cf<?php echo $cards_classes; ?>">
  <?php //if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
  <?php if ( $query -> have_posts() ) : while ( $query -> have_posts() ) : $query -> the_post(); ?>
    <?php //エントリーカードリンクタグの生成
    if ($snipet) {
      $excerpt = get_the_excerpt();
    }
    $atts = array(
      'prefix' => $prefix,
      'url' => get_the_permalink(),
      'title' => get_the_title(),
      'snippet' => $excerpt,
      'thumb_size' => $thumb_size,
      'type' => $type,
      'id' => get_the_ID(),
    );
    echo get_widgetsnipet_entry_card_link_tag($atts);
    ?>
  <?php endwhile;
  else :
    echo '<p>'.__( '記事は見つかりませんでした。', THEME_NAME ).'</p>';//見つからない時のメッセージ
  endif; ?>
  <?php wp_reset_postdata(); ?>
  <?php //wp_reset_query(); ?>
  </div>
<?php
}
endif;

//ウィジェットエントリーカードリンクタグの取得
if ( !function_exists( 'get_widgetsnipet_entry_card_link_tag' ) ):
function get_widgetsnipet_entry_card_link_tag($atts){
  extract(shortcode_atts(array(
    'prefix' => WIDGET_NEW_ENTRY_CARD_PREFIX,
    'url' => null,
    'title' => null,
    'snippet' => null,
    'thumb_size' => null,
    'image_attributes' => null,
    'ribbon_no' => null,
    'type' => null,
    'id' => null,
  ), $atts));
  //リボンタグの取得
  $ribbon_tag = get_navi_card_ribbon_tag($ribbon_no);
  ob_start(); ?>
  <a href="<?php echo esc_url($url); ?>" class="<?php echo $prefix; ?>-entry-card-link widget-entry-card-link a-wrap" title="<?php echo esc_attr($title); ?>">
    <div class="<?php echo $prefix; ?>-entry-card widget-entry-card e-card cf">
      <?php echo $ribbon_tag; ?>
      <figure class="<?php echo $prefix; ?>-entry-card-thumb widget-entry-card-thumb card-thumb">
        <?php
        if (is_widget_navi_entry_card_prefix($prefix)) {
          echo get_navi_entry_card_thumbnail_tag($image_attributes, $title);
        } else {
          echo get_widget_entry_card_thumbnail_tag($prefix, $thumb_size, $type);
        }
        ?>
      </figure><!-- /.entry-card-thumb -->

      <div class="<?php echo $prefix; ?>-entry-card-content widget-entry-card-content card-content">
        <div class="<?php echo $prefix; ?>-entry-card-title widget-entry-card-title card-title"><?php echo $title;?></div>
        <?php if ($snippet): ?>
        <div class="<?php echo $prefix; ?>-entry-card-snippet widget-entry-card-snippet card-snippet"><?php echo $snippet; ?></div>
        <?php generate_widget_entry_card_date('snipet',$id); ?>
        <?php endif; ?>
        <?php
        if (!is_widget_navi_entry_card_prefix($prefix)) {
          generate_widget_entry_card_date($prefix);
        } ?>
      </div><!-- /.entry-content -->
    </div><!-- /.entry-card -->
  </a><!-- /.entry-card-link -->
<?php
  return ob_get_clean();
}
endif;

//人気記事ショートコード関数
if (!shortcode_exists('popularsnipet_list')) {
  add_shortcode('popularsnipet_list', 'popularsnipet_entries_shortcode');
}
if ( !function_exists( 'popularsnipet_entries_shortcode' ) ):
function popularsnipet_entries_shortcode($atts) {
  extract(shortcode_atts(array(
    'days' => 'all',
    'count' => 5,
    'type' => 'default',
    'rank' => 0,
    'pv' => 0,
    'cats' => 'all',
    'bold' => 0,
    'arrow' => 0,
    'class' => null,
    'snipet' => 1,
  ), $atts));
  $cat_ids = array();
  if ($cats && $cats != 'all') {
    $cat_ids = explode(',', $cats);
  }
  $atts = array(
    'days' => $days,
    'entry_count' => $count,
    'entry_type' => $type,
    'ranking_visible' => $rank,
    'pv_visible' => $pv,
    'cat_ids' => $cat_ids,
    'bold' => $bold,
    'arrow' => $arrow,
    'class' => $class,
    'snipet' => $snipet,
  );
  ob_start();
  generate_popular_entries_tag($atts);
  //_v($atts);
  //generate_popularsnipet_entries_tag($days, $count, $type, $rank, $pv, $snipet, $categories);
  $res = ob_get_clean();
  return $res;
}
endif;

//スニペット付き人気ランキングリストの取得
if ( !function_exists( 'generate_popularsnipet_entries_tag' ) ):
function generate_popular_entries_tag($atts){
//function generate_popular_entries_tag($days = 'all', $entry_count = 5, $entry_type = ET_DEFAULT, $ranking_visible = 0, $pv_visible = 0, $cat_ids = array(), $exclude_post_ids = array(), $exclude_cat_ids = array()){
  extract(shortcode_atts(array(
    'days' => 'all',
    'entry_count' => 5,
    'entry_type' => ET_DEFAULT,
    'ranking_visible' => 0,
    'pv_visible' => 0,
    'cat_ids' => array(),
    'exclude_post_ids' => array(),
    'exclude_cat_ids' => array(),
    'bold' => 0,
    'arrow' => 0,
    'class' => null,
    'snipet' => 1,
  ), $atts));
  // if (DEBUG_MODE) {
  //   $time_start = microtime(true);
  // }
  //var_dump($cat_ids);
  //_v($atts);

  $records = get_access_ranking_records($days, $entry_count, $entry_type, $cat_ids, $exclude_post_ids, $exclude_cat_ids);

  // if (DEBUG_MODE) {
  //   $time = microtime(true) - $time_start;
  //   echo('<pre>');
  //   echo($time);
  //   echo('</pre>');
  // }

  //var_dump($records);
  $thumb_size = get_popular_entries_thumbnail_size($entry_type);
  $atts = array(
    'type' => $entry_type,
    'ranking_visible' => $ranking_visible,
    'pv_visible' => $pv_visible,
    'bold' => $bold,
    'arrow' => $arrow,
    'class' => $class,
  );
  $cards_classes = get_additional_widget_entry_cards_classes($atts);  //get_additional_popularは無くなった
  ?>
  <div class="popular-entry-cards widget-entry-cards no-icon cf<?php echo $cards_classes; ?>">
  <?php if ( $records ) :
    $i = 1;
    foreach ($records as $post):
      $permalink = get_permalink( $post->ID );
      $title = $post->post_title;
      //$no_thumbnail_url = get_template_directory_uri().'/images/no-image-320.png';
      $no_thumbnail_url = ($entry_type == ET_DEFAULT) ? get_no_image_120x68_url() : get_no_image_320x180_url();
      $w   = ($entry_type == ET_DEFAULT) ? THUMB120WIDTH  : THUMB320WIDTH;
      $h   = ($entry_type == ET_DEFAULT) ? THUMB120HEIGHT : THUMB320HEIGHT;
      //$no_thumbnail_url = get_no_image_320x180_url();

      $post_thumbnail = get_the_post_thumbnail( $post->ID, $thumb_size, array('alt' => '') );
      $pv = $post->sum_count;

      if ($post_thumbnail) {
        $post_thumbnail_img = $post_thumbnail;
      } else {
        $post_thumbnail_img = '<img src="'.$no_thumbnail_url.'" alt="" class="no-image popular-entry-card-thumb-no-image widget-entry-card-thumb-no-image" width="'.$w.'" height="'.$h.'" />';
      }

      ?>
  <a href="<?php echo $permalink; ?>" class="popular-entry-card-link a-wrap no-<?php echo $i; ?>" title="<?php echo esc_attr($title); ?>">
    <div class="popular-entry-card widget-entry-card e-card cf">
      <figure class="popular-entry-card-thumb widget-entry-card-thumb card-thumb">
        <?php echo $post_thumbnail_img; ?>
        <?php
        $is_visible = apply_filters('is_popular_entry_card_category_label_visible', false);
        $is_visible = apply_filters('is_widget_entry_card_category_label_visible', $is_visible);
        the_nolink_category($post->ID, false); //カテゴリラベルの取得 ?>
      </figure><!-- /.popular-entry-card-thumb -->

      <div class="popular-entry-card-content widget-entry-card-content card-content">
        <span class="popular-entry-card-title widget-entry-card-title card-title"><?php echo $title;?></span>
        <?php //スニペット追加
        if ($snipet) {
            //global $post;
            $post_data = get_post($post->ID);

            //メタディスクリプションの取得
            $snipetdata = get_the_page_meta_description($post->ID);

            //投稿管理画面の抜粋を取得
            if (!$snipetdata) {
              $snipetdata = $post_data->post_excerpt;
            }
            //All in One SEO Packのメタディスクリプションを取得
            if (!$snipetdata) {
              $snipetdata = get_the_all_in_one_seo_pack_meta_description($post->ID);
            }
            //記事本文の抜粋文を取得
            if (!$snipetdata) {
              $snipetdata = get_content_excerpt($post_data->post_content, get_entry_card_excerpt_max_length());
            }
            $snipetdata = preg_replace('/\n/', '', $snipetdata);
            echo '<br><div class="popular-entry-card-snippet widget-entry-card-snippet card-snippet">';
            echo $snipetdata;
            echo '</div>';
          }
        ?>
        <?php if ($pv_visible): ?>
          <span class="popular-entry-card-pv widget-entry-card-pv"><?php echo $pv == '1' ? $pv.' view' : $pv.' views';?></span>
        <?php endif ?>
        <?php generate_widget_entry_card_date('snipet', $post->ID); ?>
      </div><!-- /.popular-entry-content -->
    </div><!-- /.popular-entry-card -->
  </a><!-- /.popular-entry-card-link -->

  <?php
  $i++;
  endforeach;
  else :
    echo '<p>'.__( '人気記事は見つかりませんでした。', THEME_NAME ).'</p>';//見つからない時のメッセージ
  endif; ?>
  </div>
<?php
}
endif;
