//スニペット付き新着記事ショートコード関数
if (!shortcode_exists('newsnipet_list')) {
  add_shortcode('newsnipet_list', 'newsnipet_entries_shortcode');
}
if ( !function_exists( 'newsnipet_entries_shortcode' ) ):
function newsnipet_entries_shortcode($atts) {
  extract(shortcode_atts(array(
    'count' => 5,
    'cats' => 'all',
    'tags' => null,
    'type' => 'default',
    'children' => 0,
    'post_type' => 'post',
    'taxonomy' => 'category',
    'sticky' => 1,
    'random' => 0,
    'order' => 'desc',
    'action' => null,
    'snipet' => 1,
  ), $atts));

  //カテゴリを配列化
  $cat_ids = array();
  if ($cats && $cats != 'all') {
    $cat_ids = explode(',', $cats);
  }
  //タグを配列化
  $tag_ids = array();
  if ($tags && $tags != 'all') {
    $tag_ids = explode(',', $tags);
  }
  //引数配列のセット
  $atts = array(
    'entry_count' => $count,
    'cat_ids' => $cat_ids,
    'tag_ids' => $tag_ids,
    'entry_type' => $type,
    'include_children' => $children,
    'post_type' => $post_type,
    'taxonomy' => $taxonomy,
    'sticky' => $sticky,
    'random' => $random,
    'order' => $order,
    'action' => $action,
    'snipet' => $snipet,
  );
  ob_start();
  generate_widgetsnipet_entries_tag($atts);
  // generate_widgetsnipet_entries_tag($count, $type, $categories, $children, $post_type, $taxonomy, $random, $action, $snipet);
  $res = ob_get_clean();
  return $res;
}
endif;

//汎用エントリースニペット付きウィジェットのタグ生成
if ( !function_exists( 'generate_widgetsnipet_entries_tag' ) ):
// function generate_widgetsnipet_entries_tag($entry_count = 5, $entry_type = ET_DEFAULT, $cat_ids = array(), $include_children = 0, $post_type = null, $taxonomy = 'category', $random = 0, $action = null, $snipet = 1){
function generate_widgetsnipet_entries_tag($atts){
  extract(shortcode_atts(array(
    'entry_count' => 5,
    'cat_ids' => array(),
    'tag_ids' => array(),
    'entry_type' => ET_DEFAULT,
    'include_children' => 0,
    'post_type' => null,
    'taxonomy' => 'category',
    'sticky' => 0,
    'random' => 0,
    'order' => 'desc',
    'action' => null,
    'exclude_cat_ids' => array(),
    'snipet' => 1,
  ), $atts));
  //ランダムが有効な時は関連記事
  if ($random) {
    $prefix = 'widget-related';
  } else {
    $prefix = 'new';
  }

  $args = array(
    'posts_per_page' => $entry_count,
    'no_found_rows' => true,
    'action' => $action,
  );
  if (!$sticky) {
    $args += array(
      'post__not_in' => get_sticky_post_ids(),
    );
  }
  if ($order) {
    $args += array(
      'order' => strtoupper($order),
    );
  }
  if ($post_type) {
    $args += array(
      'post_type' => explode(',', $post_type)
    );
  }
  if ($random) {
    $args += array(
      'orderby' => 'rand'
    );
  }
  //除外カテゴリーの設定
  if (!empty($exclude_cat_ids)) {
    // _v($cat_ids);
    // _v($exclude_cat_ids);
    $cat_ids = array_diff($cat_ids, $exclude_cat_ids);
    // _v($cat_ids);
  }
  if ( $cat_ids || $tag_ids ) {
    //_v($cat_ids);
    $tax_querys = array();
    if ($cat_ids) {
      $tax_querys[] = array(
        'taxonomy' => $taxonomy,
        'terms' => $cat_ids,
        'include_children' => $include_children,
        'field' => 'term_id',
        'operator' => 'IN'
      );
    }
    if ($tag_ids) {
      $tax_querys[] = array(
        'taxonomy' => 'post_tag',
        'terms' => $tag_ids,
        'field' => 'term_id',
        'operator' => 'IN'
      );
    }
    //_v($tax_querys);
    $args += array(
      'tax_query' => array(
        $tax_querys,
        'relation' => 'AND'
      )
    );

  }
  // _v($args);
  if ($random) {
    $args = apply_filters('widget_related_entries_args', $args);
  } else {
    $args = apply_filters('widget_new_entries_args', $args);
  }
  $args = apply_filters('widget_entries_args', $args);
  //_v($args);
  $thumb_size = get_widget_entries_thumbnail_size($entry_type);
  //query_posts( $args ); //クエリの作成
  $query = new WP_Query( $args );
  ?>
  <div class="<?php echo $prefix; ?>-entry-cards widget-entry-cards no-icon cf<?php echo get_additional_widget_entriy_cards_classes($entry_type); ?>">
  <?php //if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
  <?php if ( $query -> have_posts() ) : while ( $query -> have_posts() ) : $query -> the_post(); ?>
  <a href="<?php the_permalink(); ?>" class="<?php echo $prefix; ?>-entry-card-link widget-entry-card-link a-wrap" title="<?php the_title(); ?>">
    <div class="<?php echo $prefix; ?>-entry-card widget-entry-card e-card cf">
      <figure class="<?php echo $prefix; ?>-entry-card-thumb widget-entry-card-thumb card-thumb">
      <?php if ( has_post_thumbnail() ): // サムネイルを持っているときの処理 ?>
        <?php the_post_thumbnail( $thumb_size, array('alt' => '') ); ?>
      <?php else: // サムネイルを持っていないときの処理

        $url = ($entry_type == ET_DEFAULT) ? get_no_image_120x68_url() : get_no_image_320x180_url();
        $w   = ($entry_type == ET_DEFAULT) ? THUMB120WIDTH  : THUMB320WIDTH;
        $h   = ($entry_type == ET_DEFAULT) ? THUMB120HEIGHT : THUMB320HEIGHT;

        ?>
        <img src="<?php echo $url; ?>" alt="" class="no-image <?php echo $prefix; ?>-entry-card-thumb-no-image widget-entry-card-thumb-no-image" width="<?php echo $w; ?>" height="<?php echo $h; ?>" />
      <?php endif; ?>
      <?php the_nolink_category(null, false); //カテゴリラベルの取得 ?>
      </figure><!-- /.new-entry-card-thumb -->

      <div class="<?php echo $prefix; ?>-entry-card-content widget-entry-card-content card-content myfont120">
        <span class="<?php echo $prefix; ?>-entry-card-title widget-entry-card-title card-title"><u><?php the_title();?></u></span>

      <?php //スニペット追加
        if ($snipet) {
          echo '<br><br><span class="blogcard-snipet internal-blogcard-snipet">';
          echo get_the_excerpt();
          echo '</span>';
          generate_widgetsnipet_entry_card_date($prefix,get_the_ID());
        }
      ?>

      </div><!-- /.new-entry-content -->
    </div><!-- /.new-entry-card -->
  </a><!-- /.new-entry-card-link -->
  <?php endwhile;
  else :
    echo '<p>'.__( '記事は見つかりませんでした。', THEME_NAME ).'</p>';//見つからない時のメッセージ
  endif; ?>
  <?php wp_reset_postdata(); ?>
  <?php //wp_reset_query(); ?>
  </div>
<?php
}
endif;

//人気記事ショートコード関数
if (!shortcode_exists('popularsnipet_list')) {
  add_shortcode('popularsnipet_list', 'popularsnipet_entries_shortcode');
}
if ( !function_exists( 'popularsnipet_entries_shortcode' ) ):
function popularsnipet_entries_shortcode($atts) {
  extract(shortcode_atts(array(
    'days' => 'all',
    'count' => 5,
    'type' => 'default',
    'rank' => 0,
    'pv' => 0,
    'cats' => 'all',
    'snipet' => 1,
  ), $atts));
  $categories = array();
  if ($cats && $cats != 'all') {
    $categories = explode(',', $cats);
  }
  ob_start();
  generate_popularsnipet_entries_tag($days, $count, $type, $rank, $pv, $snipet, $categories);
  $res = ob_get_clean();
  return $res;
}
endif;

//スニペット付き人気ランキングリストの取得
if ( !function_exists( 'generate_popularsnipet_entries_tag' ) ):
function generate_popularsnipet_entries_tag($days = 'all', $entry_count = 5, $entry_type = ET_DEFAULT, $ranking_visible = 0, $pv_visible = 0, $snipet = 1, $cat_ids = array(), $exclude_post_ids = array(), $exclude_cat_ids = array()){
  $records = get_access_ranking_records($days, $entry_count, $entry_type, $cat_ids, $exclude_post_ids, $exclude_cat_ids);

  //var_dump($records);
  $thumb_size = get_popular_entries_thumbnail_size($entry_type);
  ?>
  <div class="popular-entry-cards widget-entry-cards no-icon cf<?php echo get_additional_popular_entry_cards_classes($entry_type, $ranking_visible, $pv_visible, null); ?>">
  <?php if ( $records ) :
    $i = 1;
    foreach ($records as $post):
      $permalink = get_permalink( $post->ID );
      $title = $post->post_title;
      //$no_thumbnail_url = get_template_directory_uri().'/images/no-image-320.png';
      $no_thumbnail_url = ($entry_type == ET_DEFAULT) ? get_no_image_120x68_url() : get_no_image_320x180_url();
      $w   = ($entry_type == ET_DEFAULT) ? THUMB120WIDTH  : THUMB320WIDTH;
      $h   = ($entry_type == ET_DEFAULT) ? THUMB120HEIGHT : THUMB320HEIGHT;
      //$no_thumbnail_url = get_no_image_320x180_url();

      $post_thumbnail = get_the_post_thumbnail( $post->ID, $thumb_size, array('alt' => '') );
      $pv = $post->sum_count;

      if ($post_thumbnail) {
        $post_thumbnail_img = $post_thumbnail;
      } else {
        $post_thumbnail_img = '<img src="'.$no_thumbnail_url.'" alt="" class="no-image popular-entry-card-thumb-no-image widget-entry-card-thumb-no-image" width="'.$w.'" height="'.$h.'" />';
      }

      ?>
  <a href="<?php echo $permalink; ?>" class="popular-entry-card-link a-wrap no-<?php echo $i; ?>" title="<?php echo esc_attr($title); ?>">
    <div class="popular-entry-card widget-entry-card e-card cf">
      <figure class="popular-entry-card-thumb widget-entry-card-thumb card-thumb">
        <?php echo $post_thumbnail_img; ?>
        <?php the_nolink_category($post->ID, false); //カテゴリラベルの取得 ?>
      </figure><!-- /.popular-entry-card-thumb -->

      <div class="popular-entry-card-content widget-entry-card-content card-content myfont120">
        <span class="popular-entry-card-title widget-entry-card-title card-title"><u><?php echo $title;?></u></span>

        <?php //スニペット追加
        if ($snipet) {
            //global $post;
            $post_data = get_post($post->ID);

            //メタディスクリプションの取得
            $snipetdata = get_the_page_meta_description($post->ID);

            //投稿管理画面の抜粋を取得
            if (!$snipetdata) {
              $snipetdata = $post_data->post_excerpt;
            }
            //All in One SEO Packのメタディスクリプションを取得
            if (!$snipetdata) {
              $snipetdata = get_the_all_in_one_seo_pack_meta_description($post->ID);
            }
            //記事本文の抜粋文を取得
            if (!$snipetdata) {
              $snipetdata = get_content_excerpt($post_data->post_content, get_entry_card_excerpt_max_length());
            }
            $snipetdata = preg_replace('/\n/', '', $snipetdata);
            $snipetdata = apply_filters( 'cocoon_blogcard_snipet', $snipetdata );
            $snipetdata = apply_filters( 'cocoon_internal_blogcard_snipet', $snipetdata );
            echo '<br><br><span class="blogcard-snipet internal-blogcard-snipet">';
            echo $snipetdata;
            echo '</span>';
          }
        ?>

        <?php if ($pv_visible): ?>
          <span class="popular-entry-card-pv widget-entry-card-pv"><?php echo $pv == '1' ? $pv.' view' : $pv.' views';?></span>
        <?php endif ?>
        <?php generate_widgetsnipet_entry_card_date('popular', $post->ID); ?>
      </div><!-- /.popular-entry-content -->
    </div><!-- /.popular-entry-card -->
  </a><!-- /.popular-entry-card-link -->

  <?php
  $i++;
  endforeach;
  else :
    echo '<p>'.__( '人気記事は見つかりませんでした。', THEME_NAME ).'</p>';//見つからない時のメッセージ
  endif; ?>
  </div>
<?php
}
endif;

if ( !function_exists( 'generate_widgetsnipet_entry_card_date' ) ):
function generate_widgetsnipet_entry_card_date($prefix, $post_id = null){?>
<div class="<?php echo $prefix; ?>-entry-card-date widget-entry-card-date">
  <span class="<?php echo $prefix; ?>-entry-card-post-date widget-entry-card-post-date post-date"><?php echo get_the_time(get_site_date_format(), $post_id); ?></span><?php
    //更新日の取得
    $update_time = get_update_time(get_site_date_format(), $post_id);
  if($update_time):
  ?><span class="<?php echo $prefix; ?>-entry-card-update-date widget-entry-card-update-date post-update"><?php echo $update_time; ?></span><?php
  endif; ?>
</div><?php
}
endif;
