//findIndex ie11に対するpolyfill
if (!Array.prototype.findIndex) {
    Array.prototype.findIndex = function(predicate) {
      if (this === null) {
        throw new TypeError('Array.prototype.findIndex called on null or undefined');
      }
      if (typeof predicate !== 'function') {
        throw new TypeError('predicate must be a function');
      }
      var list = Object(this);
      var length = list.length >>> 0;
      var thisArg = arguments[1];
      var value;
  
      for (var i = 0; i < length; i++) {
        value = list[i];
        if (predicate.call(thisArg, value, i, list)) {
          return i;
        }
      }
      return -1;
    };
  }
//repeat polyfill
if (!String.prototype.repeat) {
    String.prototype.repeat = function(count) {
      'use strict';
      if (this == null)
        throw new TypeError('can\'t convert ' + this + ' to object');
  
      var str = '' + this;
      // To convert string to integer.
      count = +count;
      // Check NaN
      if (count != count)
        count = 0;
  
      if (count < 0)
        throw new RangeError('repeat count must be non-negative');
  
      if (count == Infinity)
        throw new RangeError('repeat count must be less than infinity');
  
      count = Math.floor(count);
      if (str.length == 0 || count == 0)
        return '';
  
      // Ensuring count is a 31-bit integer allows us to heavily optimize the
      // main part. But anyway, most current (August 2014) browsers can't handle
      // strings 1 << 28 chars or longer, so:
      if (str.length * count >= (1 << 28))
        throw new RangeError('repeat count must not overflow maximum string size');
  
      var maxCount = str.length * count;
      count = Math.floor(Math.log(count) / Math.log(2));
      while (count) {
         str += str;
         count--;
      }
      str += str.substring(0, maxCount - str.length);
      return str;
    }
}
//LeafletでのGeoJSONオブジェクト
  var g_leafletjson;

  //表示する地図を設定
var openstMap = L.tileLayer('http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png'
    ,{attribution: '<a href="https://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap</a>'} );
var gsiAttr = '国土基本情報【加工】';
var topojsonMap = L.tileLayer('', {
    attribution: gsiAttr
});

//mapとLeafletのレイヤー設定
var g_map = L.map('myMap',
    { center: g_inilatlng, zoom: g_inizoomlvl, minZoom: g_minzoomlvl,maxZoom: g_maxzoomlvl, layers: [topojsonMap] }
);

//パネル設定
g_map.createPane('labels1');
g_map.createPane('labels2');
// This pane is above markers but below popups
g_map.getPane('labels1').style.opacity = 0.3;
g_map.getPane('labels2').style.opacity = 0.6;

var gsistdMap = L.tileLayer('https://cyberjapandata.gsi.go.jp/xyz/std/{z}/{x}/{y}.png',{
    attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>地理院タイル</a>",
    pane: 'labels1'
});

var gsiblankMap = L.tileLayer('https://cyberjapandata.gsi.go.jp/xyz/blank/{z}/{x}/{y}.png',{
    attribution: "<a href='https://maps.gsi.go.jp/development/ichiran.html' target='_blank'>地理院タイル</a>",
    pane: 'labels2'
});
var mytopojson = mytopoJson;
//コントロールボックス設定
var baseLayers =  { '作成TopoJSON' : topojsonMap };
var overlayMaps = { 'OpenStreetMap' : openstMap, '地理院標準タイル' : gsistdMap, '地理院白地図タイル' : gsiblankMap};
L.control.layers(baseLayers, overlayMaps, {collapsed: false}).addTo(g_map);

//ズームバー設定
var zoomViewer = L.Control.extend({
    onAdd: function(){
        var container= L.DomUtil.create('div','zoombar');
        var gauge = L.DomUtil.create('div');
        gauge.innerHTML = 'Zoom level: ' + g_inizoomlvl;
        g_map.on('zoomstart zoom zoomend', function(bf){
            gauge.innerHTML = 'Zoom level: ' + g_map.getZoom();
        })
        container.appendChild(gauge);
        return container;
    }
});
(new zoomViewer).addTo(g_map);

//スケールバー設定
var scaleControl = L.control.scale({
    maxWidth: 200,
    position: 'bottomleft',
    imperial: false
});
scaleControl.addTo(g_map);

//topojson.jsでTopoJSONをGeoJSONに変換
function myTopo2GeoJSON() {
    mytopojson = JSON.parse(mytopojson);
    var _str = 'mytopojson.objects.' + g_jsonObjid;
    return topojson.feature(mytopojson, Function('"use strict";return (' + _str + ')')());
}

//凡例を表示
var legend = L.control({position: 'bottomright'});
legend.onAdd = function () {
    var div = L.DomUtil.create('div', 'info legend');
    div.innerHTML = g_legendTitle;
    // loop through our density intervals and generate a label with a colored square for each interval
    for (var i = 0; i < g_grades.length; i++) {
        div.innerHTML +=
            '<i style="background:' + mycolorScale(g_grades[i]) + '"></i>' +
            g_grades[i] + (g_grades[i + 1] ? '&ndash;' + (Number(g_grades[i + 1])-1) + '<br clear="left">' : '+');
    }
    return div;
}
legend.addTo(g_map);
//値に応じた色を返す
function mycolorScale(cf) {
    for (var i = 0; i < g_grades.length-1; i++) {
      if (g_grades[i] <= cf && g_grades[i+1] > cf ) return g_gradecolors[i];
    }
    return g_gradecolors[i];
  };

//地図プロパティー情報の表示
var g_info = L.control();
g_info.onAdd = function () {
    this._div = L.DomUtil.create('div', 'info'); // create a div with a class "info"
    this.update();
    return this._div;
}

//図形のハイライト強調
function highlightFeature(pf) {
    var layer = pf.target;
    layer.setStyle({
        weight: 3.0,
        opacity: 0.3,
        color: 'RGB(102,102,102)',
        fillOpacity: 0.5
    });
    g_idx = g_arrkey.findIndex(function(i) {return i === layer.feature.properties.KEY});
    g_info.update(layer.feature.properties);
    layer.bringToFront();
}
//図形のリセット
function resetHighlight(pf) {
    g_leafletjson.resetStyle(pf.target);
    g_info.update();
}

//読み込んだCSVデータを二次元配列に格納
function mysetCSVtoArray(csvdt){
    var res = [];
    var arr = csvdt.split('\t'); // タブを区切り文字として行を要素とした配列を生成
    // 各行ごとカンマ区切り文字列から二次元配列を生成
    for(var i = 0; i < arr.length; i++){
        //空白行が出てきた時点で終了
        if(arr[i] == '') break;
        //カンマ区切りで配列化
        res[i] = arr[i].split(',');
        g_arrkey[i] = arr[i].split(',')[0]; //検索キーの項目は先頭にある
    }
    return res;
}
function rvrs(str) { return str.split('').reverse().join(''); }

//承認
var approval =  L.control({position: 'bottomleft'});
approval.onAdd = function () {
    var div = L.DomUtil.create('div');
    div.innerHTML = '国土地理院長承認（使用）R 1JHs 1461';
    return div;
}
approval.addTo(g_map);